#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/sa/header.h"
#include "levels/bbh/header.h"

extern u8 _sa_segment_ESegmentRomStart[];
extern u8 _sa_segment_ESegmentRomEnd[];

const LevelScript level_sa_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _sa_segment_ESegmentRomStart, _sa_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group1_mio0SegmentRomStart, _group1_mio0SegmentRomEnd),
LOAD_RAW(12, _group1_geoSegmentRomStart, _group1_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_2),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_sa_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_sa_1_[] = {
AREA(1, Geo_sa_1_0x18da940),
TERRAIN(col_sa_1_0xe029350),
SET_BACKGROUND_MUSIC(0, 42),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_sa_1_),
JUMP_LINK(local_warps_sa_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_sa_1_[] = {
OBJECT_WITH_ACTS(0, 369, -1520, -5523, 0, 0, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(144, 355, -2518, -4134, 0, 0, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(144, 515, -2518, -4134, 0, 0, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(144, 205, -2518, -4133, 0, 0, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(124, 778, -2544, -4777, 0, 213, 0, 0x0,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(0, -3148, -1498, -3263, 0, 270, 0, 0x20000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(0, -3704, 3077, -2795, 0, 90, 0, 0x30000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(144, -3175, 1849, 6818, 0, 0, 0, 0x0,  bhvFlame, 31),
OBJECT_WITH_ACTS(212, -3802, 732, 7585, 0, 270, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(122, 3668, -2077, -3515, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 5667, 182, 6641, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(137, 2319, 530, 3951, 0, 0, 0, 0xd0000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, -4074, 1532, 7493, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -5179, 3497, -1162, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(137, 6338, 3630, -229, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(207, 6309, 3151, -136, 0, 0, 0, 0x0,  bhvFloorSwitchHiddenObjects, 31),
OBJECT_WITH_ACTS(129, 6286, 2940, -1191, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6281, 2580, -1753, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6288, 1980, -2286, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6320, 690, -3005, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6314, -54, -3429, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 5908, -1560, -3428, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 5358, -2292, -3478, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(0, 3645, 1464, -3478, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(215, 3662, 4404, -3477, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 3626, -630, -3536, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1369, 2402, -4019, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1509, 1784, -3442, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 26, 3575, -3025, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1231, 3350, -1929, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 662, 2948, -1241, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1169, 2585, -921, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(116, 2022, 948, 3710, 0, 180, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, 2022, 948, 3710, 0, 180, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, -3563, 1530, 5626, 0, 122, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, -3563, 1530, 5626, 0, 122, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, -2659, 1511, 1569, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, -2659, 1511, 1569, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, -3778, 2580, 1639, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, -3778, 2580, 1639, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(116, -4815, 4320, 1818, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(0, -4815, 4320, 1818, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, -6025, 4991, 627, 0, 0, 0, 0x6000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(217, 2396, -108, 3973, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 2396, -108, 3662, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 2396, -318, 3353, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(207, 3844, -3898, 4287, 0, 0, 0, 0x0,  bhvFloorSwitchHiddenObjects, 31),
OBJECT_WITH_ACTS(129, 6609, -3301, 3760, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 6609, -3098, 3955, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(0, 3626, -636, -3536, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(223, 239, -1648, 3352, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 235, -2548, -2866, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(194, -4102, -1246, 1378, 0, 0, 0, 0x0,  bhvHomingAmp, 31),
OBJECT_WITH_ACTS(194, 362, -1246, 5041, 0, 0, 0, 0x0,  bhvHomingAmp, 31),
OBJECT_WITH_ACTS(0, 3645, 1464, -3478, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -3563, 1530, 5626, 0, 122, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(88, -5006, 3077, -4174, 0, 180, 0, 0x0,  bhvThwomp, 31),
OBJECT_WITH_ACTS(88, 359, -1648, 5051, 0, 180, 0, 0x0,  bhvThwomp, 31),
OBJECT_WITH_ACTS(0, 3840, -1588, 4321, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 3626, -636, -3536, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 371, -1648, 2452, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 350, -2548, -3611, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, -3026, 3432, 6558, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -4225, 3432, 6588, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -4260, 3432, 4910, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -3060, 3432, 4910, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 353, -2220, -1153, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(180, 2639, 3077, -4500, 0, 360, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 2639, 3077, -2382, 0, 180, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -4157, -1606, -434, 0, 180, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 374, -1930, -9, 0, 180, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -3110, -1300, 2121, 0, 180, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 6013, -244, 3902, 0, 180, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(137, 3831, -2830, 4288, 0, 0, 0, 0x10000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(217, 7108, -2550, 3185, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 7099, -2850, 3479, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(0, -3574, -2173, 3538, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(137, -3930, -2880, 3594, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(129, -3166, 1427, 6818, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(0, -3166, 1427, 6270, 0, 0, 0, 0x40000,  bhvCoinFormation, 31),
RETURN()
};

const LevelScript local_warps_sa_1_[] = {
WARP_NODE(10, 12, 1, 1, 0),
WARP_NODE(2, 20, 1, 3, 0),
WARP_NODE(3, 20, 1, 2, 0),
WARP_NODE(240, 6, 3, 47, 0),
WARP_NODE(241, 6, 3, 57, 0),
RETURN()
};
